<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Generatedcard> $generatedcards
 */
?>
<div class="generatedcards index content">
    <?= $this->Html->link(__('New Generatedcard'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Generatedcards') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('cardbatch_id') ?></th>
                    <th><?= $this->Paginator->sort('card_number') ?></th>
                    <th><?= $this->Paginator->sort('status') ?></th>
                    <th><?= $this->Paginator->sort('creation_date') ?></th>
                    <th><?= $this->Paginator->sort('card_type') ?></th>
                    <th><?= $this->Paginator->sort('date_in_transit') ?></th>
                    <th><?= $this->Paginator->sort('date_delivered') ?></th>
                    <th><?= $this->Paginator->sort('date_assigned') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($generatedcards as $generatedcard): ?>
                <tr>
                    <td><?= $this->Number->format($generatedcard->id) ?></td>
                    <td><?= $generatedcard->has('cardbatch') ? $this->Html->link($generatedcard->cardbatch->id, ['controller' => 'Cardbatches', 'action' => 'view', $generatedcard->cardbatch->id]) : '' ?></td>
                    <td><?= h($generatedcard->card_number) ?></td>
                    <td><?= h($generatedcard->status) ?></td>
                    <td><?= h($generatedcard->creation_date) ?></td>
                    <td><?= h($generatedcard->card_type) ?></td>
                    <td><?= h($generatedcard->date_in_transit) ?></td>
                    <td><?= h($generatedcard->date_delivered) ?></td>
                    <td><?= h($generatedcard->date_assigned) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $generatedcard->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $generatedcard->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $generatedcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $generatedcard->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
