<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Institution $institution
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Institution'), ['action' => 'edit', $institution->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Institution'), ['action' => 'delete', $institution->id], ['confirm' => __('Are you sure you want to delete # {0}?', $institution->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Institutions'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Institution'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="institutions view content">
            <h3><?= h($institution->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($institution->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Code') ?></th>
                    <td><?= h($institution->code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($institution->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Description') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($institution->description)); ?>
                </blockquote>
            </div>
            <div class="related">
                <h4><?= __('Related Products') ?></h4>
                <?php if (!empty($institution->products)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Institution Id') ?></th>
                            <th><?= __('Name') ?></th>
                            <th><?= __('Description') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($institution->products as $products) : ?>
                        <tr>
                            <td><?= h($products->id) ?></td>
                            <td><?= h($products->institution_id) ?></td>
                            <td><?= h($products->name) ?></td>
                            <td><?= h($products->description) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Products', 'action' => 'view', $products->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Products', 'action' => 'edit', $products->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Products', 'action' => 'delete', $products->id], ['confirm' => __('Are you sure you want to delete # {0}?', $products->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Requestcards') ?></h4>
                <?php if (!empty($institution->requestcards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Institution Id') ?></th>
                            <th><?= __('Product Id') ?></th>
                            <th><?= __('Branch Id') ?></th>
                            <th><?= __('User Id') ?></th>
                            <th><?= __('Requested Date') ?></th>
                            <th><?= __('Total Cards') ?></th>
                            <th><?= __('Status') ?></th>
                            <th><?= __('Card Type') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($institution->requestcards as $requestcards) : ?>
                        <tr>
                            <td><?= h($requestcards->id) ?></td>
                            <td><?= h($requestcards->institution_id) ?></td>
                            <td><?= h($requestcards->product_id) ?></td>
                            <td><?= h($requestcards->branch_id) ?></td>
                            <td><?= h($requestcards->user_id) ?></td>
                            <td><?= h($requestcards->requested_date) ?></td>
                            <td><?= h($requestcards->total_cards) ?></td>
                            <td><?= h($requestcards->status) ?></td>
                            <td><?= h($requestcards->card_type) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Requestcards', 'action' => 'view', $requestcards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Requestcards', 'action' => 'edit', $requestcards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Requestcards', 'action' => 'delete', $requestcards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $requestcards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
