<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Lostcard> $lostcards
 */
?>
<div class="lostcards index content">
    <?= $this->Html->link(__('New Lostcard'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Lostcards') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('customer_id') ?></th>
                    <th><?= $this->Paginator->sort('account_id') ?></th>
                    <th><?= $this->Paginator->sort('generatedcard_id') ?></th>
                    <th><?= $this->Paginator->sort('card_number') ?></th>
                    <th><?= $this->Paginator->sort('date_reported') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($lostcards as $lostcard): ?>
                <tr>
                    <td><?= $this->Number->format($lostcard->id) ?></td>
                    <td><?= $lostcard->has('customer') ? $this->Html->link($lostcard->customer->id, ['controller' => 'Customers', 'action' => 'view', $lostcard->customer->id]) : '' ?></td>
                    <td><?= $lostcard->has('account') ? $this->Html->link($lostcard->account->id, ['controller' => 'Accounts', 'action' => 'view', $lostcard->account->id]) : '' ?></td>
                    <td><?= $lostcard->has('generatedcard') ? $this->Html->link($lostcard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $lostcard->generatedcard->id]) : '' ?></td>
                    <td><?= h($lostcard->card_number) ?></td>
                    <td><?= h($lostcard->date_reported) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $lostcard->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $lostcard->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $lostcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $lostcard->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
