<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Region $region
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Region'), ['action' => 'edit', $region->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Region'), ['action' => 'delete', $region->id], ['confirm' => __('Are you sure you want to delete # {0}?', $region->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Regions'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Region'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="regions view content">
            <h3><?= h($region->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('PsgcCode') ?></th>
                    <td><?= h($region->psgcCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('RegCode') ?></th>
                    <td><?= h($region->regCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($region->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('RegDesc') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($region->regDesc)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
