<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Replacementcard> $replacementcards
 */
?>
<div class="replacementcards index content">
    <?= $this->Html->link(__('New Replacementcard'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Replacementcards') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('customer_id') ?></th>
                    <th><?= $this->Paginator->sort('account_id') ?></th>
                    <th><?= $this->Paginator->sort('generatedcard_id') ?></th>
                    <th><?= $this->Paginator->sort('from_cardno') ?></th>
                    <th><?= $this->Paginator->sort('to_gen') ?></th>
                    <th><?= $this->Paginator->sort('to_cardno') ?></th>
                    <th><?= $this->Paginator->sort('replace_date') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($replacementcards as $replacementcard): ?>
                <tr>
                    <td><?= $this->Number->format($replacementcard->id) ?></td>
                    <td><?= $replacementcard->has('customer') ? $this->Html->link($replacementcard->customer->id, ['controller' => 'Customers', 'action' => 'view', $replacementcard->customer->id]) : '' ?></td>
                    <td><?= $replacementcard->has('account') ? $this->Html->link($replacementcard->account->id, ['controller' => 'Accounts', 'action' => 'view', $replacementcard->account->id]) : '' ?></td>
                    <td><?= $replacementcard->has('generatedcard') ? $this->Html->link($replacementcard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $replacementcard->generatedcard->id]) : '' ?></td>
                    <td><?= h($replacementcard->from_cardno) ?></td>
                    <td><?= $this->Number->format($replacementcard->to_gen) ?></td>
                    <td><?= h($replacementcard->to_cardno) ?></td>
                    <td><?= h($replacementcard->replace_date) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $replacementcard->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $replacementcard->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $replacementcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $replacementcard->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
