<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Requestcard $requestcard
 * @var \Cake\Collection\CollectionInterface|string[] $institutions
 * @var \Cake\Collection\CollectionInterface|string[] $products
 * @var \Cake\Collection\CollectionInterface|string[] $branches
 * @var \Cake\Collection\CollectionInterface|string[] $users
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Requestcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="requestcards form content">
            <?= $this->Form->create($requestcard) ?>
            <fieldset>
                <legend><?= __('Add Requestcard') ?></legend>
                <?php
                    echo $this->Form->control('institution_id', ['options' => $institutions]);
                    echo $this->Form->control('product_id', ['options' => $products]);
                    echo $this->Form->control('branch_id', ['options' => $branches]);
                    echo $this->Form->control('user_id', ['options' => $users]);
                    echo $this->Form->control('requested_date');
                    echo $this->Form->control('total_cards');
                    echo $this->Form->control('status');
                    echo $this->Form->control('card_type');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
