<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Requestcard $requestcard
 * @var string[]|\Cake\Collection\CollectionInterface $institutions
 * @var string[]|\Cake\Collection\CollectionInterface $products
 * @var string[]|\Cake\Collection\CollectionInterface $branches
 * @var string[]|\Cake\Collection\CollectionInterface $users
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $requestcard->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $requestcard->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Requestcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="requestcards form content">
            <?= $this->Form->create($requestcard) ?>
            <fieldset>
                <legend><?= __('Edit Requestcard') ?></legend>
                <?php
                    echo $this->Form->control('institution_id', ['options' => $institutions]);
                    echo $this->Form->control('product_id', ['options' => $products]);
                    echo $this->Form->control('branch_id', ['options' => $branches]);
                    echo $this->Form->control('user_id', ['options' => $users]);
                    echo $this->Form->control('requested_date');
                    echo $this->Form->control('total_cards');
                    echo $this->Form->control('status');
                    echo $this->Form->control('card_type');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
