<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Stolencard $stolencard
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Stolencard'), ['action' => 'edit', $stolencard->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Stolencard'), ['action' => 'delete', $stolencard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $stolencard->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Stolencards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Stolencard'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="stolencards view content">
            <h3><?= h($stolencard->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Customer') ?></th>
                    <td><?= $stolencard->has('customer') ? $this->Html->link($stolencard->customer->id, ['controller' => 'Customers', 'action' => 'view', $stolencard->customer->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Account') ?></th>
                    <td><?= $stolencard->has('account') ? $this->Html->link($stolencard->account->id, ['controller' => 'Accounts', 'action' => 'view', $stolencard->account->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Generatedcard') ?></th>
                    <td><?= $stolencard->has('generatedcard') ? $this->Html->link($stolencard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $stolencard->generatedcard->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Card Number') ?></th>
                    <td><?= h($stolencard->card_number) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($stolencard->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date Reported') ?></th>
                    <td><?= h($stolencard->date_reported) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
