<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Appsetting $appsetting
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Appsetting'), ['action' => 'edit', $appsetting->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Appsetting'), ['action' => 'delete', $appsetting->id], ['confirm' => __('Are you sure you want to delete # {0}?', $appsetting->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Appsettings'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Appsetting'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="appsettings view content">
            <h3><?= h($appsetting->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('AppSettingID') ?></th>
                    <td><?= h($appsetting->AppSettingID) ?></td>
                </tr>
                <tr>
                    <th><?= __('Value') ?></th>
                    <td><?= h($appsetting->Value) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($appsetting->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
