<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Ballot $ballot
 * @var string[]|\Cake\Collection\CollectionInterface $precincts
 * @var string[]|\Cake\Collection\CollectionInterface $elections
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $ballot->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $ballot->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Ballots'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="ballots form content">
            <?= $this->Form->create($ballot) ?>
            <fieldset>
                <legend><?= __('Edit Ballot') ?></legend>
                <?php
                    echo $this->Form->control('qr_code');
                    echo $this->Form->control('precinct_id', ['options' => $precincts]);
                    echo $this->Form->control('election_id', ['options' => $elections]);
                    echo $this->Form->control('is_validated');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
