<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Ballot $ballot
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Ballot'), ['action' => 'edit', $ballot->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Ballot'), ['action' => 'delete', $ballot->id], ['confirm' => __('Are you sure you want to delete # {0}?', $ballot->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Ballots'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Ballot'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="ballots view content">
            <h3><?= h($ballot->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Qr Code') ?></th>
                    <td><?= h($ballot->qr_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Precinct') ?></th>
                    <td><?= $ballot->has('precinct') ? $this->Html->link($ballot->precinct->id, ['controller' => 'Precincts', 'action' => 'view', $ballot->precinct->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Election') ?></th>
                    <td><?= $ballot->has('election') ? $this->Html->link($ballot->election->name, ['controller' => 'Elections', 'action' => 'view', $ballot->election->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($ballot->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Is Validated') ?></th>
                    <td><?= $ballot->is_validated ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
