<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Barangay $barangay
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Barangay'), ['action' => 'edit', $barangay->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Barangay'), ['action' => 'delete', $barangay->id], ['confirm' => __('Are you sure you want to delete # {0}?', $barangay->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Barangays'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Barangay'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="barangays view content">
            <h3><?= h($barangay->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('BrgyCode') ?></th>
                    <td><?= h($barangay->brgyCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('RegCode') ?></th>
                    <td><?= h($barangay->regCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('ProvCode') ?></th>
                    <td><?= h($barangay->provCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('CitymunCode') ?></th>
                    <td><?= h($barangay->citymunCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($barangay->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('BrgyDesc') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($barangay->brgyDesc)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
