<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Batch> $batches
 */
?>
<div class="batches index content">
    <?= $this->Html->link(__('New Batch'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Batches') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th><?= $this->Paginator->sort('total_ballots') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($batches as $batch): ?>
                <tr>
                    <td><?= $this->Number->format($batch->id) ?></td>
                    <td><?= h($batch->created) ?></td>
                    <td><?= $this->Number->format($batch->total_ballots) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $batch->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $batch->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $batch->id], ['confirm' => __('Are you sure you want to delete # {0}?', $batch->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
