<?= $this->Html->css('vendors/css/vendor.bundle.base.css', ['fullBase' => true]) ?>
<?= $this->Html->css('vertical-layout-light/style.css', ['fullBase' => true]) ?>
<?= $this->Html->css('datatables.css', ['fullBase' => true]) ?>
<?= $this->Html->css('custom.css', ['fullBase' => true]) ?>
 
<!DOCTYPE html>
<html>
<head>
<title>Candidates Report</title>
</head>
<body>
	
<div class="fs-10 bold">Report : </span class="text-danger"><?php echo $report_name; ?></span> </div>
<div class="fs-10 bold">Election : </span class="text-danger"><?php echo $election_name; ?></span> </div>
<div class="fs-10 bold">Position : </span class="text-danger"><?php echo $position_name; ?></span> </div>
<hr>
<div class="fs-10 bold">Date Generated : </span class="text-danger"><?php echo date('m/d/Y h:i A'); ?></span> </div>
<hr>
<table id="dtable" class="table table-condensed">
						<thead>
							<tr class="text-uppercase">
								<th><span class="fs-9">Look</span></th>
								<th><span class="fs-9">Name</span></th>
								<th><span class="fs-9">Registered</span></th>
								<th><span class="fs-9">Status</span></th>
								<th><span class="fs-9">Election</span></th>
								<th><span class="fs-9">Position</span></th>
							</tr>
						</thead>
						<tbody>
							<?php if(!empty($candidates)): ?>
								<?php foreach($candidates as $c): ?>
									<tr>
										<td>
										<?php 
											
											if(!empty($c->avatar)){
												$img = '<img src="'.$c->avatar.'" alt="image" class="profile-pic" />';
											}else{
												$img = $this->Html->image("faces/face3.jpg",
													["alt" => "image", "class" => "profile-pic", 'fullBase' => true]
												);
											}
											
											echo $this->Html->link('
											<div class="preview-thumbnail">
												'.$img.'
											</div>',
											['controller' => 'users', 'action' => 'view-user-profile/'.$c->refid.'-'.$c->id],
											['title' => 'Member Profile', 'escape' => false, 'data-toggle' => 'modal', 'data-target' => '#view_modal', 'class' => 'modal_view']	
											); ?>
										</td>
										<td><div class="bold text-uppercase fs-9"><?php echo $c->name; ?></div></td>
										<td><div class="fs-9"><?php echo date('m/d/Y', strtotime($c->created)); ?></div></td>
										<td class="bold text-<?php echo strtolower($c->status); ?>"><div class="fs-9"><?php echo $c->status; ?></div></td>	
										<td> 
											<div class="fs-9"><?php echo $c->election->name; ?></div>
										</td>
										<td>
											<div class="bold fs-9"><?php echo $c->officerposition->name; ?></div>
										</td>
										
									</tr>
								<?php endforeach; ?>
							<?php endif; ?>
						</tbody>
					</table>
	
</body>
</html>

