<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Candidate $candidate
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Candidate'), ['action' => 'edit', $candidate->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Candidate'), ['action' => 'delete', $candidate->id], ['confirm' => __('Are you sure you want to delete # {0}?', $candidate->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Candidates'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Candidate'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="candidates view content">
            <h3><?= h($candidate->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($candidate->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Party Affiliation') ?></th>
                    <td><?= h($candidate->party_affiliation) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($candidate->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Position Id') ?></th>
                    <td><?= $this->Number->format($candidate->position_id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
