<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Cbuschedule> $cbuschedules
 */
?>
<div class="cbuschedules index content">
    <?= $this->Html->link(__('New Cbuschedule'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Cbuschedules') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('member_id') ?></th>
                    <th><?= $this->Paginator->sort('Pay5') ?></th>
                    <th><?= $this->Paginator->sort('Pay20') ?></th>
                    <th><?= $this->Paginator->sort('Total') ?></th>
                    <th><?= $this->Paginator->sort('CreatedDate') ?></th>
                    <th><?= $this->Paginator->sort('UpdatedDate') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($cbuschedules as $cbuschedule): ?>
                <tr>
                    <td><?= $this->Number->format($cbuschedule->id) ?></td>
                    <td><?= $cbuschedule->has('member') ? $this->Html->link($cbuschedule->member->id, ['controller' => 'Members', 'action' => 'view', $cbuschedule->member->id]) : '' ?></td>
                    <td><?= h($cbuschedule->Pay5) ?></td>
                    <td><?= h($cbuschedule->Pay20) ?></td>
                    <td><?= h($cbuschedule->Total) ?></td>
                    <td><?= h($cbuschedule->CreatedDate) ?></td>
                    <td><?= h($cbuschedule->UpdatedDate) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $cbuschedule->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $cbuschedule->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $cbuschedule->id], ['confirm' => __('Are you sure you want to delete # {0}?', $cbuschedule->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
