<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cbuschedule $cbuschedule
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Cbuschedule'), ['action' => 'edit', $cbuschedule->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Cbuschedule'), ['action' => 'delete', $cbuschedule->id], ['confirm' => __('Are you sure you want to delete # {0}?', $cbuschedule->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Cbuschedules'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Cbuschedule'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="cbuschedules view content">
            <h3><?= h($cbuschedule->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Member') ?></th>
                    <td><?= $cbuschedule->has('member') ? $this->Html->link($cbuschedule->member->id, ['controller' => 'Members', 'action' => 'view', $cbuschedule->member->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Pay5') ?></th>
                    <td><?= h($cbuschedule->Pay5) ?></td>
                </tr>
                <tr>
                    <th><?= __('Pay20') ?></th>
                    <td><?= h($cbuschedule->Pay20) ?></td>
                </tr>
                <tr>
                    <th><?= __('Total') ?></th>
                    <td><?= h($cbuschedule->Total) ?></td>
                </tr>
                <tr>
                    <th><?= __('CreatedDate') ?></th>
                    <td><?= h($cbuschedule->CreatedDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('UpdatedDate') ?></th>
                    <td><?= h($cbuschedule->UpdatedDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($cbuschedule->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
