<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Changerequest> $changerequests
 */
?>
<div class="changerequests index content">
    <?= $this->Html->link(__('New Changerequest'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Changerequests') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('member_id') ?></th>
                    <th><?= $this->Paginator->sort('type') ?></th>
                    <th><?= $this->Paginator->sort('status') ?></th>
                    <th><?= $this->Paginator->sort('status_date') ?></th>
                    <th><?= $this->Paginator->sort('status_by') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($changerequests as $changerequest): ?>
                <tr>
                    <td><?= $this->Number->format($changerequest->id) ?></td>
                    <td><?= $changerequest->has('member') ? $this->Html->link($changerequest->member->id, ['controller' => 'Members', 'action' => 'view', $changerequest->member->id]) : '' ?></td>
                    <td><?= h($changerequest->type) ?></td>
                    <td><?= h($changerequest->status) ?></td>
                    <td><?= h($changerequest->status_date) ?></td>
                    <td><?= $changerequest->status_by === null ? '' : $this->Number->format($changerequest->status_by) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $changerequest->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $changerequest->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $changerequest->id], ['confirm' => __('Are you sure you want to delete # {0}?', $changerequest->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
