<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Changerequest $changerequest
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Changerequest'), ['action' => 'edit', $changerequest->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Changerequest'), ['action' => 'delete', $changerequest->id], ['confirm' => __('Are you sure you want to delete # {0}?', $changerequest->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Changerequests'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Changerequest'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="changerequests view content">
            <h3><?= h($changerequest->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Member') ?></th>
                    <td><?= $changerequest->has('member') ? $this->Html->link($changerequest->member->id, ['controller' => 'Members', 'action' => 'view', $changerequest->member->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Type') ?></th>
                    <td><?= h($changerequest->type) ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= h($changerequest->status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($changerequest->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Status By') ?></th>
                    <td><?= $changerequest->status_by === null ? '' : $this->Number->format($changerequest->status_by) ?></td>
                </tr>
                <tr>
                    <th><?= __('Status Date') ?></th>
                    <td><?= h($changerequest->status_date) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Change From') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($changerequest->change_from)); ?>
                </blockquote>
            </div>
            <div class="text">
                <strong><?= __('Change To') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($changerequest->change_to)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
