<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Chartaccountnews> $chartaccountnews
 */
?>
<div class="chartaccountnews index content">
    <?= $this->Html->link(__('New Chartaccountnews'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Chartaccountnews') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('int') ?></th>
                    <th><?= $this->Paginator->sort('AccountCode') ?></th>
                    <th><?= $this->Paginator->sort('AccountName') ?></th>
                    <th><?= $this->Paginator->sort('AccountType') ?></th>
                    <th><?= $this->Paginator->sort('ParentCode') ?></th>
                    <th><?= $this->Paginator->sort('SummaryAccount') ?></th>
                    <th><?= $this->Paginator->sort('GLDebit') ?></th>
                    <th><?= $this->Paginator->sort('GLCredit') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($chartaccountnews as $chartaccountnews): ?>
                <tr>
                    <td><?= $this->Number->format($chartaccountnews->int) ?></td>
                    <td><?= h($chartaccountnews->AccountCode) ?></td>
                    <td><?= h($chartaccountnews->AccountName) ?></td>
                    <td><?= h($chartaccountnews->AccountType) ?></td>
                    <td><?= h($chartaccountnews->ParentCode) ?></td>
                    <td><?= h($chartaccountnews->SummaryAccount) ?></td>
                    <td><?= h($chartaccountnews->GLDebit) ?></td>
                    <td><?= h($chartaccountnews->GLCredit) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $chartaccountnews->int]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $chartaccountnews->int]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $chartaccountnews->int], ['confirm' => __('Are you sure you want to delete # {0}?', $chartaccountnews->int)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
