<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Electioncandidate> $electioncandidates
 */
?>
<div class="electioncandidates index content">
    <?= $this->Html->link(__('New Electioncandidate'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Electioncandidates') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('election_id') ?></th>
                    <th><?= $this->Paginator->sort('candidate_id') ?></th>
                    <th><?= $this->Paginator->sort('votes_received') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($electioncandidates as $electioncandidate): ?>
                <tr>
                    <td><?= $this->Number->format($electioncandidate->id) ?></td>
                    <td><?= $electioncandidate->has('election') ? $this->Html->link($electioncandidate->election->name, ['controller' => 'Elections', 'action' => 'view', $electioncandidate->election->id]) : '' ?></td>
                    <td><?= $electioncandidate->has('candidate') ? $this->Html->link($electioncandidate->candidate->name, ['controller' => 'Candidates', 'action' => 'view', $electioncandidate->candidate->id]) : '' ?></td>
                    <td><?= $electioncandidate->votes_received === null ? '' : $this->Number->format($electioncandidate->votes_received) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $electioncandidate->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $electioncandidate->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $electioncandidate->id], ['confirm' => __('Are you sure you want to delete # {0}?', $electioncandidate->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
