<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Electioncandidate $electioncandidate
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Electioncandidate'), ['action' => 'edit', $electioncandidate->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Electioncandidate'), ['action' => 'delete', $electioncandidate->id], ['confirm' => __('Are you sure you want to delete # {0}?', $electioncandidate->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Electioncandidates'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Electioncandidate'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="electioncandidates view content">
            <h3><?= h($electioncandidate->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Election') ?></th>
                    <td><?= $electioncandidate->has('election') ? $this->Html->link($electioncandidate->election->name, ['controller' => 'Elections', 'action' => 'view', $electioncandidate->election->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Candidate') ?></th>
                    <td><?= $electioncandidate->has('candidate') ? $this->Html->link($electioncandidate->candidate->name, ['controller' => 'Candidates', 'action' => 'view', $electioncandidate->candidate->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($electioncandidate->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Votes Received') ?></th>
                    <td><?= $electioncandidate->votes_received === null ? '' : $this->Number->format($electioncandidate->votes_received) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
