<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Election $election
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $election->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $election->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Elections'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="elections form content">
            <?= $this->Form->create($election) ?>
            <fieldset>
                <legend><?= __('Edit Election') ?></legend>
                <?php
                    echo $this->Form->control('name');
                    echo $this->Form->control('type');
                    echo $this->Form->control('date', ['empty' => true]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
