<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Election $election
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Election'), ['action' => 'edit', $election->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Election'), ['action' => 'delete', $election->id], ['confirm' => __('Are you sure you want to delete # {0}?', $election->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Elections'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Election'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="elections view content">
            <h3><?= h($election->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($election->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Type') ?></th>
                    <td><?= h($election->type) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($election->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date') ?></th>
                    <td><?= h($election->date) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Ballots') ?></h4>
                <?php if (!empty($election->ballots)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Qr Code') ?></th>
                            <th><?= __('Precinct Id') ?></th>
                            <th><?= __('Election Id') ?></th>
                            <th><?= __('Is Validated') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($election->ballots as $ballots) : ?>
                        <tr>
                            <td><?= h($ballots->id) ?></td>
                            <td><?= h($ballots->qr_code) ?></td>
                            <td><?= h($ballots->precinct_id) ?></td>
                            <td><?= h($ballots->election_id) ?></td>
                            <td><?= h($ballots->is_validated) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Ballots', 'action' => 'view', $ballots->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Ballots', 'action' => 'edit', $ballots->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Ballots', 'action' => 'delete', $ballots->id], ['confirm' => __('Are you sure you want to delete # {0}?', $ballots->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Electioncandidates') ?></h4>
                <?php if (!empty($election->electioncandidates)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Election Id') ?></th>
                            <th><?= __('Candidate Id') ?></th>
                            <th><?= __('Votes Received') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($election->electioncandidates as $electioncandidates) : ?>
                        <tr>
                            <td><?= h($electioncandidates->id) ?></td>
                            <td><?= h($electioncandidates->election_id) ?></td>
                            <td><?= h($electioncandidates->candidate_id) ?></td>
                            <td><?= h($electioncandidates->votes_received) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Electioncandidates', 'action' => 'view', $electioncandidates->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Electioncandidates', 'action' => 'edit', $electioncandidates->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Electioncandidates', 'action' => 'delete', $electioncandidates->id], ['confirm' => __('Are you sure you want to delete # {0}?', $electioncandidates->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
