<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Generalledgersummary> $generalledgersummaries
 */
?>
<div class="generalledgersummaries index content">
    <?= $this->Html->link(__('New Generalledgersummary'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Generalledgersummaries') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('Period') ?></th>
                    <th><?= $this->Paginator->sort('AccountCode') ?></th>
                    <th><?= $this->Paginator->sort('Debit') ?></th>
                    <th><?= $this->Paginator->sort('Credit') ?></th>
                    <th><?= $this->Paginator->sort('YearToDateDebit') ?></th>
                    <th><?= $this->Paginator->sort('YearToDateCredit') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($generalledgersummaries as $generalledgersummary): ?>
                <tr>
                    <td><?= $this->Number->format($generalledgersummary->id) ?></td>
                    <td><?= h($generalledgersummary->Period) ?></td>
                    <td><?= h($generalledgersummary->AccountCode) ?></td>
                    <td><?= h($generalledgersummary->Debit) ?></td>
                    <td><?= h($generalledgersummary->Credit) ?></td>
                    <td><?= h($generalledgersummary->YearToDateDebit) ?></td>
                    <td><?= h($generalledgersummary->YearToDateCredit) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $generalledgersummary->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $generalledgersummary->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $generalledgersummary->id], ['confirm' => __('Are you sure you want to delete # {0}?', $generalledgersummary->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
