<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Generalledgersummary $generalledgersummary
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Generalledgersummary'), ['action' => 'edit', $generalledgersummary->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Generalledgersummary'), ['action' => 'delete', $generalledgersummary->id], ['confirm' => __('Are you sure you want to delete # {0}?', $generalledgersummary->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Generalledgersummaries'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Generalledgersummary'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="generalledgersummaries view content">
            <h3><?= h($generalledgersummary->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Period') ?></th>
                    <td><?= h($generalledgersummary->Period) ?></td>
                </tr>
                <tr>
                    <th><?= __('AccountCode') ?></th>
                    <td><?= h($generalledgersummary->AccountCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('Debit') ?></th>
                    <td><?= h($generalledgersummary->Debit) ?></td>
                </tr>
                <tr>
                    <th><?= __('Credit') ?></th>
                    <td><?= h($generalledgersummary->Credit) ?></td>
                </tr>
                <tr>
                    <th><?= __('YearToDateDebit') ?></th>
                    <td><?= h($generalledgersummary->YearToDateDebit) ?></td>
                </tr>
                <tr>
                    <th><?= __('YearToDateCredit') ?></th>
                    <td><?= h($generalledgersummary->YearToDateCredit) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($generalledgersummary->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
