<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Loandetail $loandetail
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Loandetail'), ['action' => 'edit', $loandetail->Id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Loandetail'), ['action' => 'delete', $loandetail->Id], ['confirm' => __('Are you sure you want to delete # {0}?', $loandetail->Id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Loandetails'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Loandetail'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="loandetails view content">
            <h3><?= h($loandetail->Id) ?></h3>
            <table>
                <tr>
                    <th><?= __('AmortizationDate') ?></th>
                    <td><?= h($loandetail->AmortizationDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= h($loandetail->Status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Remarks') ?></th>
                    <td><?= h($loandetail->Remarks) ?></td>
                </tr>
                <tr>
                    <th><?= __('EntryDate') ?></th>
                    <td><?= h($loandetail->EntryDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('UpdateDateTime') ?></th>
                    <td><?= h($loandetail->UpdateDateTime) ?></td>
                </tr>
                <tr>
                    <th><?= __('PayDate') ?></th>
                    <td><?= h($loandetail->PayDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($loandetail->Id) ?></td>
                </tr>
                <tr>
                    <th><?= __('LoanMasterId') ?></th>
                    <td><?= $loandetail->LoanMasterId === null ? '' : $this->Number->format($loandetail->LoanMasterId) ?></td>
                </tr>
                <tr>
                    <th><?= __('MonthlyAmortization') ?></th>
                    <td><?= $loandetail->MonthlyAmortization === null ? '' : $this->Number->format($loandetail->MonthlyAmortization) ?></td>
                </tr>
                <tr>
                    <th><?= __('Principal') ?></th>
                    <td><?= $loandetail->Principal === null ? '' : $this->Number->format($loandetail->Principal) ?></td>
                </tr>
                <tr>
                    <th><?= __('Interest') ?></th>
                    <td><?= $loandetail->Interest === null ? '' : $this->Number->format($loandetail->Interest) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
