<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Memberschildren $memberschildren
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Memberschildren'), ['action' => 'edit', $memberschildren->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Memberschildren'), ['action' => 'delete', $memberschildren->id], ['confirm' => __('Are you sure you want to delete # {0}?', $memberschildren->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Memberschildrens'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Memberschildren'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="memberschildrens view content">
            <h3><?= h($memberschildren->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Member') ?></th>
                    <td><?= $memberschildren->has('member') ? $this->Html->link($memberschildren->member->id, ['controller' => 'Members', 'action' => 'view', $memberschildren->member->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('ChildName') ?></th>
                    <td><?= h($memberschildren->ChildName) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($memberschildren->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
