<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Monthlydeduction $monthlydeduction
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Monthlydeduction'), ['action' => 'edit', $monthlydeduction->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Monthlydeduction'), ['action' => 'delete', $monthlydeduction->id], ['confirm' => __('Are you sure you want to delete # {0}?', $monthlydeduction->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Monthlydeductions'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Monthlydeduction'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="monthlydeductions view content">
            <h3><?= h($monthlydeduction->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Member') ?></th>
                    <td><?= $monthlydeduction->has('member') ? $this->Html->link($monthlydeduction->member->id, ['controller' => 'Members', 'action' => 'view', $monthlydeduction->member->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('DatePaid') ?></th>
                    <td><?= h($monthlydeduction->DatePaid) ?></td>
                </tr>
                <tr>
                    <th><?= __('Remarks') ?></th>
                    <td><?= h($monthlydeduction->Remarks) ?></td>
                </tr>
                <tr>
                    <th><?= __('EntryDate') ?></th>
                    <td><?= h($monthlydeduction->EntryDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('UpdateDateTime') ?></th>
                    <td><?= h($monthlydeduction->UpdateDateTime) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($monthlydeduction->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('ArrearsAmount') ?></th>
                    <td><?= $monthlydeduction->ArrearsAmount === null ? '' : $this->Number->format($monthlydeduction->ArrearsAmount) ?></td>
                </tr>
                <tr>
                    <th><?= __('InterestArrears') ?></th>
                    <td><?= $monthlydeduction->InterestArrears === null ? '' : $this->Number->format($monthlydeduction->InterestArrears) ?></td>
                </tr>
                <tr>
                    <th><?= __('DeductionAmount') ?></th>
                    <td><?= $monthlydeduction->DeductionAmount === null ? '' : $this->Number->format($monthlydeduction->DeductionAmount) ?></td>
                </tr>
                <tr>
                    <th><?= __('RiceAmount') ?></th>
                    <td><?= $monthlydeduction->RiceAmount === null ? '' : $this->Number->format($monthlydeduction->RiceAmount) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
