<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Precinct $precinct
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $precinct->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $precinct->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Precincts'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="precincts form content">
            <?= $this->Form->create($precinct) ?>
            <fieldset>
                <legend><?= __('Edit Precinct') ?></legend>
                <?php
                    echo $this->Form->control('clustered');
                    echo $this->Form->control('location');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
