<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Precinct> $precincts
 */
?>
<div class="precincts index content">
    <?= $this->Html->link(__('New Precinct'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Precincts') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('clustered') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($precincts as $precinct): ?>
                <tr>
                    <td><?= $this->Number->format($precinct->id) ?></td>
                    <td><?= h($precinct->clustered) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $precinct->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $precinct->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $precinct->id], ['confirm' => __('Are you sure you want to delete # {0}?', $precinct->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
