<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Precinct $precinct
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Precinct'), ['action' => 'edit', $precinct->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Precinct'), ['action' => 'delete', $precinct->id], ['confirm' => __('Are you sure you want to delete # {0}?', $precinct->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Precincts'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Precinct'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="precincts view content">
            <h3><?= h($precinct->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Clustered') ?></th>
                    <td><?= h($precinct->clustered) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($precinct->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Location') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($precinct->location)); ?>
                </blockquote>
            </div>
            <div class="related">
                <h4><?= __('Related Ballots') ?></h4>
                <?php if (!empty($precinct->ballots)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Qr Code') ?></th>
                            <th><?= __('Precinct Id') ?></th>
                            <th><?= __('Election Id') ?></th>
                            <th><?= __('Is Validated') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($precinct->ballots as $ballots) : ?>
                        <tr>
                            <td><?= h($ballots->id) ?></td>
                            <td><?= h($ballots->qr_code) ?></td>
                            <td><?= h($ballots->precinct_id) ?></td>
                            <td><?= h($ballots->election_id) ?></td>
                            <td><?= h($ballots->is_validated) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Ballots', 'action' => 'view', $ballots->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Ballots', 'action' => 'edit', $ballots->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Ballots', 'action' => 'delete', $ballots->id], ['confirm' => __('Are you sure you want to delete # {0}?', $ballots->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
