<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Province $province
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Province'), ['action' => 'edit', $province->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Province'), ['action' => 'delete', $province->id], ['confirm' => __('Are you sure you want to delete # {0}?', $province->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Provinces'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Province'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="provinces view content">
            <h3><?= h($province->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('PsgcCode') ?></th>
                    <td><?= h($province->psgcCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('RegCode') ?></th>
                    <td><?= h($province->regCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('ProvCode') ?></th>
                    <td><?= h($province->provCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($province->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('ProvDesc') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($province->provDesc)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
