<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Transactiondetail $transactiondetail
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Transactiondetail'), ['action' => 'edit', $transactiondetail->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Transactiondetail'), ['action' => 'delete', $transactiondetail->id], ['confirm' => __('Are you sure you want to delete # {0}?', $transactiondetail->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Transactiondetails'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Transactiondetail'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="transactiondetails view content">
            <h3><?= h($transactiondetail->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('TransactionCode') ?></th>
                    <td><?= h($transactiondetail->TransactionCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('TransactionDate') ?></th>
                    <td><?= h($transactiondetail->TransactionDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('AccountCode') ?></th>
                    <td><?= h($transactiondetail->AccountCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('EntryDate') ?></th>
                    <td><?= h($transactiondetail->EntryDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($transactiondetail->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('TransactionNumber') ?></th>
                    <td><?= $transactiondetail->TransactionNumber === null ? '' : $this->Number->format($transactiondetail->TransactionNumber) ?></td>
                </tr>
                <tr>
                    <th><?= __('Debit') ?></th>
                    <td><?= $transactiondetail->Debit === null ? '' : $this->Number->format($transactiondetail->Debit) ?></td>
                </tr>
                <tr>
                    <th><?= __('Credit') ?></th>
                    <td><?= $transactiondetail->Credit === null ? '' : $this->Number->format($transactiondetail->Credit) ?></td>
                </tr>
                <tr>
                    <th><?= __('Sequence') ?></th>
                    <td><?= $transactiondetail->Sequence === null ? '' : $this->Number->format($transactiondetail->Sequence) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
