<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Transactionlog $transactionlog
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Transactionlog'), ['action' => 'edit', $transactionlog->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Transactionlog'), ['action' => 'delete', $transactionlog->id], ['confirm' => __('Are you sure you want to delete # {0}?', $transactionlog->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Transactionlogs'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Transactionlog'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="transactionlogs view content">
            <h3><?= h($transactionlog->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('RowId') ?></th>
                    <td><?= h($transactionlog->RowId) ?></td>
                </tr>
                <tr>
                    <th><?= __('TransactionDate') ?></th>
                    <td><?= h($transactionlog->TransactionDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('UserId') ?></th>
                    <td><?= h($transactionlog->UserId) ?></td>
                </tr>
                <tr>
                    <th><?= __('TableName') ?></th>
                    <td><?= h($transactionlog->TableName) ?></td>
                </tr>
                <tr>
                    <th><?= __('TransName') ?></th>
                    <td><?= h($transactionlog->TransName) ?></td>
                </tr>
                <tr>
                    <th><?= __('DeviceName') ?></th>
                    <td><?= h($transactionlog->DeviceName) ?></td>
                </tr>
                <tr>
                    <th><?= __('Reference1') ?></th>
                    <td><?= h($transactionlog->Reference1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Reference2') ?></th>
                    <td><?= h($transactionlog->Reference2) ?></td>
                </tr>
                <tr>
                    <th><?= __('Reference3') ?></th>
                    <td><?= h($transactionlog->Reference3) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($transactionlog->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Description') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($transactionlog->Description)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
