<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Trialbalancebeginning> $trialbalancebeginnings
 */
?>
<div class="trialbalancebeginnings index content">
    <?= $this->Html->link(__('New Trialbalancebeginning'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Trialbalancebeginnings') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('Period') ?></th>
                    <th><?= $this->Paginator->sort('AccountCode') ?></th>
                    <th><?= $this->Paginator->sort('AccountName') ?></th>
                    <th><?= $this->Paginator->sort('Debit') ?></th>
                    <th><?= $this->Paginator->sort('Credit') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($trialbalancebeginnings as $trialbalancebeginning): ?>
                <tr>
                    <td><?= $this->Number->format($trialbalancebeginning->id) ?></td>
                    <td><?= h($trialbalancebeginning->Period) ?></td>
                    <td><?= h($trialbalancebeginning->AccountCode) ?></td>
                    <td><?= h($trialbalancebeginning->AccountName) ?></td>
                    <td><?= h($trialbalancebeginning->Debit) ?></td>
                    <td><?= h($trialbalancebeginning->Credit) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $trialbalancebeginning->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $trialbalancebeginning->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $trialbalancebeginning->id], ['confirm' => __('Are you sure you want to delete # {0}?', $trialbalancebeginning->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
