<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Usercasting> $usercastings
 */
?>
<div class="usercastings index content">
    <?= $this->Html->link(__('New Usercasting'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Usercastings') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('user_id') ?></th>
                    <th><?= $this->Paginator->sort('election_id') ?></th>
                    <th><?= $this->Paginator->sort('votecasting_count') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($usercastings as $usercasting): ?>
                <tr>
                    <td><?= $this->Number->format($usercasting->id) ?></td>
                    <td><?= $usercasting->has('user') ? $this->Html->link($usercasting->user->id, ['controller' => 'Users', 'action' => 'view', $usercasting->user->id]) : '' ?></td>
                    <td><?= $usercasting->has('election') ? $this->Html->link($usercasting->election->name, ['controller' => 'Elections', 'action' => 'view', $usercasting->election->id]) : '' ?></td>
                    <td><?= h($usercasting->votecasting_count) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $usercasting->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $usercasting->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $usercasting->id], ['confirm' => __('Are you sure you want to delete # {0}?', $usercasting->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
