<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Usercasting $usercasting
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Usercasting'), ['action' => 'edit', $usercasting->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Usercasting'), ['action' => 'delete', $usercasting->id], ['confirm' => __('Are you sure you want to delete # {0}?', $usercasting->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Usercastings'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Usercasting'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="usercastings view content">
            <h3><?= h($usercasting->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('User') ?></th>
                    <td><?= $usercasting->has('user') ? $this->Html->link($usercasting->user->id, ['controller' => 'Users', 'action' => 'view', $usercasting->user->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Election') ?></th>
                    <td><?= $usercasting->has('election') ? $this->Html->link($usercasting->election->name, ['controller' => 'Elections', 'action' => 'view', $usercasting->election->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Votecasting Count') ?></th>
                    <td><?= h($usercasting->votecasting_count) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($usercasting->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
