<?= $this->Html->css('vendors/css/vendor.bundle.base.css', ['fullBase' => true]) ?>
<?= $this->Html->css('vertical-layout-light/style.css', ['fullBase' => true]) ?>
<?= $this->Html->css('datatables.css', ['fullBase' => true]) ?>
<?= $this->Html->css('custom.css', ['fullBase' => true]) ?>
 
<!DOCTYPE html>
<html>
<head>
<title>Account Report</title>
</head>
<body>
	
<div class="fs-10 bold">Report : </span class="text-danger"><?php echo $report_name; ?></span> </div>
<div class="fs-10 bold">Account Role : </span class="text-danger"><?php echo $account_role; ?></span> </div>
<div class="fs-10 bold">Account Status : </span class="text-danger"><?php echo $account_status; ?></span> </div>
<hr>
<div class="fs-10 bold">Date Generated : </span class="text-danger"><?php echo date('m/d/Y h:i A'); ?></span> </div>
<hr>
<table id="dtable" class="table table-condensed table-striped">
						<thead>
							<tr class="text-uppercase">
								<th><span class="fs-9">Look</span></th>
								<th><span class="fs-9">Name</span></th>
								<th><span class="fs-9">Contact</span></th>
								<th><span class="fs-9">Last Access</span></th>
								<th><span class="fs-9">Status</span></th>
							</tr>
						</thead>
						<tbody>
							<?php if(!empty($users)): ?>
								<?php foreach($users as $u): ?>
									<tr>
										<td> 
											<?php 
											
											if(!empty($u->avatar)){
												$img = '<img src="'.$u->avatar.'" alt="image" class="profile-pic" />';
											}else{
												$img = $this->Html->image("faces/face3.jpg",
													["alt" => "image", "class" => "profile-pic", 'fullBase' => true]
												);
											}
											
											echo '<div class="preview-thumbnail">
												'.$img.'
											</div>';
											
											?>
										</td>
										<td>
											<span class="fs-9 bold text-uppercase"><?php echo $u->firstname.' '.$u->lastname; ?></span>
											<div class="fs-7 text-warning"><?php echo strtoupper($u->group->name); ?></div>
										</td>
										<td><span class="fs-9">
											<div class="fs-8"><?php echo $u->contact_no; ?></div>
											<div class="fs-8"><?php echo $u->email; ?></div>
										</span></td>
										<td><span class="fs-9"><?php echo !empty($u->last_login) ? date('m/d/Y', strtotime($u->last_login)) : "-"; ?></span></td>
										<td class="bold"><span class="fs-9"><?php echo ($u->status=="ACTIVE") ? '<span class="text-success">'.$u->status.'</span>' : '<span class="text-danger">'.$u->status.'</span>'; ?></span></td>
										
									</tr>
								<?php endforeach; ?>
							<?php endif; ?>
						</tbody>
					</table>
</body>
</html>

