<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 * @var \Cake\Collection\CollectionInterface|string[] $groups
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Users'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="users form content">
            <?= $this->Form->create($user) ?>
            <fieldset>
                <legend><?= __('Add User') ?></legend>
                <?php
                    echo $this->Form->control('group_id', ['options' => $groups]);
                    echo $this->Form->control('refid');
                    echo $this->Form->control('username', ['default' => 'admin']);
                    echo $this->Form->control('password', ['default' => 'admin']);
                    echo $this->Form->control('status', ['default' => 'ACTIVE']);
                    echo $this->Form->control('contact_no', ['default' => '09054122663']);
                    echo $this->Form->control('email', ['default' => 'nit.conqueror@gmail.com']);
                    echo $this->Form->control('firstname', ['default' => 'System']);
                    echo $this->Form->control('middlename');
                    echo $this->Form->control('lastname', ['default' => 'Administrator']);
                    echo $this->Form->control('member_no');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
