<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Worksheet> $worksheets
 */
?>
<div class="worksheets index content">
    <?= $this->Html->link(__('New Worksheet'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Worksheets') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('EntryID') ?></th>
                    <th><?= $this->Paginator->sort('AccountCode') ?></th>
                    <th><?= $this->Paginator->sort('Description') ?></th>
                    <th><?= $this->Paginator->sort('Bal_Dr') ?></th>
                    <th><?= $this->Paginator->sort('Bal_Cr') ?></th>
                    <th><?= $this->Paginator->sort('CT_Dr') ?></th>
                    <th><?= $this->Paginator->sort('CT_Cr') ?></th>
                    <th><?= $this->Paginator->sort('UTB_Dr') ?></th>
                    <th><?= $this->Paginator->sort('UTB_Cr') ?></th>
                    <th><?= $this->Paginator->sort('CurentAdj_Dr') ?></th>
                    <th><?= $this->Paginator->sort('CurrentAdj_Cr') ?></th>
                    <th><?= $this->Paginator->sort('AdjTB_Dr') ?></th>
                    <th><?= $this->Paginator->sort('AdjTB_Cr') ?></th>
                    <th><?= $this->Paginator->sort('IS_Dr') ?></th>
                    <th><?= $this->Paginator->sort('IS_Cr') ?></th>
                    <th><?= $this->Paginator->sort('BS_Dr') ?></th>
                    <th><?= $this->Paginator->sort('BS_Cr') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($worksheets as $worksheet): ?>
                <tr>
                    <td><?= $this->Number->format($worksheet->id) ?></td>
                    <td><?= $worksheet->EntryID === null ? '' : $this->Number->format($worksheet->EntryID) ?></td>
                    <td><?= h($worksheet->AccountCode) ?></td>
                    <td><?= h($worksheet->Description) ?></td>
                    <td><?= $worksheet->Bal_Dr === null ? '' : $this->Number->format($worksheet->Bal_Dr) ?></td>
                    <td><?= $worksheet->Bal_Cr === null ? '' : $this->Number->format($worksheet->Bal_Cr) ?></td>
                    <td><?= $worksheet->CT_Dr === null ? '' : $this->Number->format($worksheet->CT_Dr) ?></td>
                    <td><?= $worksheet->CT_Cr === null ? '' : $this->Number->format($worksheet->CT_Cr) ?></td>
                    <td><?= $worksheet->UTB_Dr === null ? '' : $this->Number->format($worksheet->UTB_Dr) ?></td>
                    <td><?= $worksheet->UTB_Cr === null ? '' : $this->Number->format($worksheet->UTB_Cr) ?></td>
                    <td><?= $worksheet->CurentAdj_Dr === null ? '' : $this->Number->format($worksheet->CurentAdj_Dr) ?></td>
                    <td><?= $worksheet->CurrentAdj_Cr === null ? '' : $this->Number->format($worksheet->CurrentAdj_Cr) ?></td>
                    <td><?= $worksheet->AdjTB_Dr === null ? '' : $this->Number->format($worksheet->AdjTB_Dr) ?></td>
                    <td><?= $worksheet->AdjTB_Cr === null ? '' : $this->Number->format($worksheet->AdjTB_Cr) ?></td>
                    <td><?= $worksheet->IS_Dr === null ? '' : $this->Number->format($worksheet->IS_Dr) ?></td>
                    <td><?= $worksheet->IS_Cr === null ? '' : $this->Number->format($worksheet->IS_Cr) ?></td>
                    <td><?= $worksheet->BS_Dr === null ? '' : $this->Number->format($worksheet->BS_Dr) ?></td>
                    <td><?= $worksheet->BS_Cr === null ? '' : $this->Number->format($worksheet->BS_Cr) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $worksheet->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $worksheet->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $worksheet->id], ['confirm' => __('Are you sure you want to delete # {0}?', $worksheet->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
