<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Worksheet $worksheet
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Worksheet'), ['action' => 'edit', $worksheet->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Worksheet'), ['action' => 'delete', $worksheet->id], ['confirm' => __('Are you sure you want to delete # {0}?', $worksheet->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Worksheets'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Worksheet'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="worksheets view content">
            <h3><?= h($worksheet->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('AccountCode') ?></th>
                    <td><?= h($worksheet->AccountCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('Description') ?></th>
                    <td><?= h($worksheet->Description) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($worksheet->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('EntryID') ?></th>
                    <td><?= $worksheet->EntryID === null ? '' : $this->Number->format($worksheet->EntryID) ?></td>
                </tr>
                <tr>
                    <th><?= __('Bal Dr') ?></th>
                    <td><?= $worksheet->Bal_Dr === null ? '' : $this->Number->format($worksheet->Bal_Dr) ?></td>
                </tr>
                <tr>
                    <th><?= __('Bal Cr') ?></th>
                    <td><?= $worksheet->Bal_Cr === null ? '' : $this->Number->format($worksheet->Bal_Cr) ?></td>
                </tr>
                <tr>
                    <th><?= __('CT Dr') ?></th>
                    <td><?= $worksheet->CT_Dr === null ? '' : $this->Number->format($worksheet->CT_Dr) ?></td>
                </tr>
                <tr>
                    <th><?= __('CT Cr') ?></th>
                    <td><?= $worksheet->CT_Cr === null ? '' : $this->Number->format($worksheet->CT_Cr) ?></td>
                </tr>
                <tr>
                    <th><?= __('UTB Dr') ?></th>
                    <td><?= $worksheet->UTB_Dr === null ? '' : $this->Number->format($worksheet->UTB_Dr) ?></td>
                </tr>
                <tr>
                    <th><?= __('UTB Cr') ?></th>
                    <td><?= $worksheet->UTB_Cr === null ? '' : $this->Number->format($worksheet->UTB_Cr) ?></td>
                </tr>
                <tr>
                    <th><?= __('CurentAdj Dr') ?></th>
                    <td><?= $worksheet->CurentAdj_Dr === null ? '' : $this->Number->format($worksheet->CurentAdj_Dr) ?></td>
                </tr>
                <tr>
                    <th><?= __('CurrentAdj Cr') ?></th>
                    <td><?= $worksheet->CurrentAdj_Cr === null ? '' : $this->Number->format($worksheet->CurrentAdj_Cr) ?></td>
                </tr>
                <tr>
                    <th><?= __('AdjTB Dr') ?></th>
                    <td><?= $worksheet->AdjTB_Dr === null ? '' : $this->Number->format($worksheet->AdjTB_Dr) ?></td>
                </tr>
                <tr>
                    <th><?= __('AdjTB Cr') ?></th>
                    <td><?= $worksheet->AdjTB_Cr === null ? '' : $this->Number->format($worksheet->AdjTB_Cr) ?></td>
                </tr>
                <tr>
                    <th><?= __('IS Dr') ?></th>
                    <td><?= $worksheet->IS_Dr === null ? '' : $this->Number->format($worksheet->IS_Dr) ?></td>
                </tr>
                <tr>
                    <th><?= __('IS Cr') ?></th>
                    <td><?= $worksheet->IS_Cr === null ? '' : $this->Number->format($worksheet->IS_Cr) ?></td>
                </tr>
                <tr>
                    <th><?= __('BS Dr') ?></th>
                    <td><?= $worksheet->BS_Dr === null ? '' : $this->Number->format($worksheet->BS_Dr) ?></td>
                </tr>
                <tr>
                    <th><?= __('BS Cr') ?></th>
                    <td><?= $worksheet->BS_Cr === null ? '' : $this->Number->format($worksheet->BS_Cr) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
