<div>
    <?php $assessments = $member->members_assessments; ?>

    <?php foreach ($plantypes as $types) : ?>
        <?php
        // Find the corresponding assessment in the assessments array
        $assessment = false;
        $with_loan = false;
        $with_advance_payment = false;
        $plan_id = "";
        $pay_upto = date("m/d/Y", strtotime("+1 month"));
        $total_premium = "";
        $total_benefits = "";
        $a_id = "";
        $unit_plan = "";
        if (!empty($assessments)) :
            foreach ($assessments as $assess) {
                if ($assess->plantype_id === $types->id) {
                    $assessment = true;
                    $with_loan = ($assess->with_loan == 1) ? true : false;
                    $with_advance_payment = ($assess->with_advance_payment == 1) ? true : false;
                    $plan_id = !empty($assess->plan_id) ? $assess->plan_id : "";
                    $unit_plan = !empty($assess->unit_plan) ? $assess->unit_plan : "";
                    $pay_upto = !empty($assess->pay_upto) ? date("m/d/Y", strtotime($assess->pay_upto)) : date("m/d/Y", strtotime("+1 month"));
                    $total_premium = !empty($assess->total_premium) ? $assess->total_premium : "";
                    $total_benefits = !empty($assess->total_benefits) ? $assess->total_benefits : "";
                    $a_id = !empty($assess->id) ? $assess->id : "";

                    break;
                }
            }
        endif;

        ?>

        <div class="col-12 row">
            <label class="col-md-2 btn-xs btn-outline-success">
                <input type="checkbox" name="plans[]" value="<?php echo $types->id; ?>" <?php echo ($assessment) ? 'checked' : ''; ?> />
                <span class="bold text-primary"><?php echo $types->name; ?></span>
            </label>
            <input type="hidden" name="a_id[<?php echo $types->id; ?>]" value="<?php echo $a_id; ?>" />
            <div class="col-1">
                <div>
                    <div>
                        <?php
                        echo $this->Form->checkbox("with_loan.{$types->id}", [
                            'class' => 'form-check-input',
                            'value' => '1', // Set the value for the checkbox when checked
                            'label' => false, // Hide the label (you can add a label manually if needed)
                            'checked' => ($with_loan) ? 'checked' : ''
                            // 'checked' => ($with_loan) ? 'checked' : ''
                        ]);

                        $this->Form->unlockField('a_id');
                        $this->Form->unlockField('plans');
                        $this->Form->unlockField('amount');
                        ?>
                        <label for="with_loan_<?php echo $types->id; ?>" class="fs-10 form-check-label text-success text-uppercase">With Loan</label>
                    </div>

                    <div>
                        <?php
                        echo $this->Form->checkbox("with_advance_payment.{$types->id}", [
                            'class' => 'form-check-input',
                            'value' => '1', // Set the value for the checkbox when checked
                            'label' => false, // Hide the label (you can add a label manually if needed)
                            'checked' => ($with_advance_payment) ? 'checked' : ''
                        ]);
                        ?>
                        <label for="with_advance_payment" class="fs-10 form-check-label text-success text-uppercase">With Advance Payment</label>
                    </div>
                </div>
            </div>

            <div class="col-2 form-floating">
                <?php
                // Define options for this plan type
                $typeOptions = [];

                if (!empty($types->members_plans)) {
                    foreach ($types->members_plans as $plan) {
                        // Add plan options to the $typeOptions array
                        $typeOptions[$plan->id] = strtoupper($plan->code) . ' - PHP ' . strtoupper($plan->amount);
                    }
                }

                // Generate a dynamic ID for each select input
                $selectId = 'plan_select_' . $types->id;

                // Generate a dynamic input name with array notation
                $inputName = 'plan_id[' . $types->id . ']';

                echo $this->Form->control(
                    $inputName, // Input name with array notation
                    [
                        'label' => false,
                        'type' => 'select',
                        'empty' => '--Select',
                        'default' => $plan_id,
                        'options' => $typeOptions, // Use specific options for this plan type
                        'class' => 'form-control bold plan-select', // Shared class for styling or event handling
                        'data-id' => $types->id,
                        'id' => $selectId, // Unique ID for each select input
                        'placeholder' => 'Select Plan Code'
                    ]
                );
                ?>
                <label for="<?php echo $selectId; ?>" class="fs-10 text-success text-uppercase">Plan Code / Amount</label>
            </div>

            <div class="col-2 form-floating">
                <?php
                echo $this->Form->select("unit_plan.{$types->id}", [
                    'Remove' => 'Remove',
                    'Plan 50' => 'Plan 50',
                    'Plan 75' => 'Plan 75',
                    'Plan 100' => 'Plan 100',
                ], [
                    'default' => $unit_plan,
                    'class' => 'form-control',
                    'placeholder' => 'Select an Option',
                ]);
                ?>
                <label for="select_input_name" class="fs-10 text-success text-uppercase">Unit Plan</label>
            </div>

            <div class="form-floating col-2">
                <?php echo $this->Form->input("pay_upto.{$types->id}", ['type' => 'text', 'default' => $pay_upto, 'id' => 'pay_upto_' . $types->id, 'class' => 'date form-control', 'placeholder' => 'Pay Upto']); ?>
                <label for="pay_upto" class="fs-10 text-success text-uppercase">Pay Upto (mm/dd/YYYY)</label>
            </div>

            <div class="form-floating col-1">
                <?php echo $this->Form->input("total_premium.{$types->id}", ['id' => 'total_premium_' . $types->id, 'default' => $total_premium, 'class' => 'form-control', 'placeholder' => 'Total Premium']); ?>
                <label for="total_premium" class="fs-10 text-success text-uppercase">Total Premium</label>
            </div>

            <div class="form-floating col-1">
                <?php echo $this->Form->input("total_benefits.{$types->id}", ['id' => 'total_benefits_' . $types->id, 'default' => $total_benefits,  'class' => 'form-control', 'placeholder' => 'Total Benefits']); ?>
                <label for="total_benefits" class="fs-10 text-success text-uppercase">Total Benefits</label>
            </div>
        </div>
        <!-- Hidden fields -->
        <?php
        echo $this->Form->control("amount.{$types->id}", [
            'class' => 'form-control amount',
            'label' => false,
            'type' => 'hidden',
            'id' => 'amount_' . $types->id,
            'escape' => false,
        ]);
        ?>

    <?php endforeach; ?>
</div>
<?php

echo $this->Html->scriptStart(['block' => 'scriptBottom']);
echo '$(document).ready(function() {
			// Attach change event handler to the plan_id select element
			function calculateMonthsBetweenDates(startDate, endDate) {
				var months;
				
				// Calculate the difference in months
				months = (endDate.getFullYear() - startDate.getFullYear()) * 12;
				months -= startDate.getMonth();
				months += endDate.getMonth();
				
				return months;
			}

			
			function isValidDate(dateString) {
				var regEx = /^\d{2}\/\d{2}\/\d{4}$/;
				return dateString.match(regEx) !== null;
			}
	
			
			$(".plan-select").change(function() {
				var _id = $(this).attr("id");
				var id = $(this).attr("data-id");
			
				//$("#pay_upto").focusout(function() {
				 // Get the selected plan_id and its corresponding amount
				var selectedPlanId = $("#" + _id + " option:selected").text();
				var selectedAmount = parseFloat(selectedPlanId.split(" - PHP ")[1]);
				$("#amount_" + id).val(selectedAmount);
				
				// Get the value of pay_upto as a date
				var payUpto = new Date($("#pay_upto_" + id).val());
				var payUptoDate = new Date(payUpto);

				// Get the current date
				var currentDate = new Date();
				var monthsDifference = calculateMonthsBetweenDates(currentDate, payUptoDate);
				
				var totalPremium = (selectedAmount * monthsDifference); // Customize this calculation as needed
				var totalBenefits = (selectedAmount * monthsDifference); // Customize this calculation as needed

				// Set the computed values in the respective input fields
				$("#total_premium_" + id).val(totalPremium.toFixed(2)); // Display with 2 decimal places
				$("#total_benefits_" + id).val(totalBenefits.toFixed(2)); // Display with 2 decimal places
				
			});
		});';

echo $this->Html->scriptEnd();

?>