<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;

use Cake\Http\Response;
use Cake\Controller\Controller;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;

class BallotsController extends AppController
{
    
	public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
    public function index(){
        $this->paginate = [
            'contain' => ['Precincts', 'Elections'],
        ];
        $ballots = $this->paginate($this->Ballots);

        $this->set(compact('ballots'));
    }
	
	public function printable(){
		
	}
	
	public function decryptcode($code=null){
		$this->viewBuilder()->setLayout('ajax');
				$this->autoRender = false;
				$this->view = false;
				
		if(isset($code) && !empty($code)){
			if($code=="R60kY6CDVNsBgsdl9lrOshGTjLOgNe3vvGBkEkhe76jJYiUPdmvgndQyjegNbtGwOshGTjLOgNe3vvGBkEkhe76jJYiUPdmvgndQyjegNbtGw"){
				$data = [
					'precinct' 	=> '0126A',
					'batch'		=> 1,
					'generated_date' => date("Y-m-d H:i:s"),
					'election' => 1,
					'location'  => 'Test Location'
				];
			
				echo json_encode($data);
				exit();
			}
		}
	}
	
	
	public function generateQrCode()
    {
        // Data to be encoded in the QR Code
		/* $data = [
			'precinct' 	=> '0126A',
			'batch'		=> 1,
			'generated_date' => date("Y-m-d H:i:s"),
			'election' => 1,
			'location'  => 'Test Location'
		];
		
		$data = base64_encode(json_encode($data));		 */	
		
		$data = "R60kY6CDVNsBgsdl9lrOshGTjLOgNe3vvGBkEkhe76jJYiUPdmvgndQyjegNbtGwOshGTjLOgNe3vvGBkEkhe76jJYiUPdmvgndQyjegNbtGw";
        //$data = 'https://www.example.com';

        // Create a QR code object
        $qrCode = QrCode::create($data)
                        ->setSize(300)
                        ->setMargin(10);

        // Create a writer instance
        $writer = new PngWriter();

        // Generate the QR code image
        $result = $writer->write($qrCode);

        // Get QR code image data as string
        $qrCodeString = $result->getString();

        // Create a response with the QR code PNG image
        $response = $this->response->withType('image/png')
                                   ->withStringBody($qrCodeString);

        // Disable CakePHP's default layout rendering
        $this->viewBuilder()->disableAutoLayout();

        return $response;
    }
	
	public function add(){
		
			$ballot = $this->Ballots->newEmptyEntity();
			
			
			if ($this->request->is('post')) {
				$this->ajaxLayout();
				$code = 0;
				
				$data = $this->request->getData();				
				$ballot = $this->Ballots->patchEntity($ballot, $data,  ['validate' => false]);
				
				$error = $this->showError($ballot);
						
				if(!empty($error)) {
					$this->Log(json_encode($ballot->getErrors()));
					$msg = '<span class="text-danger">'.$error.'</span>';
				}else{
					$ballot->created = date("Y-m-d H:i:s");
					
					if ($this->Ballots->save($ballot)) {
						$code = 1; 
						$msg = '<span class="text-success">New data successfully registered</span>';
					}else{
						$error = $this->showError($ballot);
						$this->Log(json_encode($ballot->getErrors()));
						$msg = '<span class="text-danger">'.$error.'</span>';
					}
				} 
					
				$resp = ['code' => $code, 'msg' => $msg];
				
				
				$this->response = $this->response->withType('application/json')
				->withStringBody(json_encode($resp));
				
				return $this->response;
			}

			$this->set(compact('ballot'));
		
    }
	
	

}
