<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Barangays Controller
 *
 * @property \App\Model\Table\BarangaysTable $Barangays
 * @method \App\Model\Entity\Barangay[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class BarangaysController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $barangays = $this->paginate($this->Barangays);

        $this->set(compact('barangays'));
    }

    /**
     * View method
     *
     * @param string|null $id Barangay id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $barangay = $this->Barangays->get($id, [
            'contain' => [],
        ]);

        $this->set(compact('barangay'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $barangay = $this->Barangays->newEmptyEntity();
        if ($this->request->is('post')) {
            $barangay = $this->Barangays->patchEntity($barangay, $this->request->getData());
            if ($this->Barangays->save($barangay)) {
                $this->Flash->success(__('The barangay has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The barangay could not be saved. Please, try again.'));
        }
        $this->set(compact('barangay'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Barangay id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $barangay = $this->Barangays->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $barangay = $this->Barangays->patchEntity($barangay, $this->request->getData());
            if ($this->Barangays->save($barangay)) {
                $this->Flash->success(__('The barangay has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The barangay could not be saved. Please, try again.'));
        }
        $this->set(compact('barangay'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Barangay id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $barangay = $this->Barangays->get($id);
        if ($this->Barangays->delete($barangay)) {
            $this->Flash->success(__('The barangay has been deleted.'));
        } else {
            $this->Flash->error(__('The barangay could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
