<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Cbuschedules Controller
 *
 * @property \App\Model\Table\CbuschedulesTable $Cbuschedules
 * @method \App\Model\Entity\Cbuschedule[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class CbuschedulesController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Members'],
        ];
        $cbuschedules = $this->paginate($this->Cbuschedules);

        $this->set(compact('cbuschedules'));
    }

    /**
     * View method
     *
     * @param string|null $id Cbuschedule id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $cbuschedule = $this->Cbuschedules->get($id, [
            'contain' => ['Members'],
        ]);

        $this->set(compact('cbuschedule'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $cbuschedule = $this->Cbuschedules->newEmptyEntity();
        if ($this->request->is('post')) {
            $cbuschedule = $this->Cbuschedules->patchEntity($cbuschedule, $this->request->getData());
            if ($this->Cbuschedules->save($cbuschedule)) {
                $this->Flash->success(__('The cbuschedule has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The cbuschedule could not be saved. Please, try again.'));
        }
        $members = $this->Cbuschedules->Members->find('list', ['limit' => 200])->all();
        $this->set(compact('cbuschedule', 'members'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Cbuschedule id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $cbuschedule = $this->Cbuschedules->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $cbuschedule = $this->Cbuschedules->patchEntity($cbuschedule, $this->request->getData());
            if ($this->Cbuschedules->save($cbuschedule)) {
                $this->Flash->success(__('The cbuschedule has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The cbuschedule could not be saved. Please, try again.'));
        }
        $members = $this->Cbuschedules->Members->find('list', ['limit' => 200])->all();
        $this->set(compact('cbuschedule', 'members'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Cbuschedule id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $cbuschedule = $this->Cbuschedules->get($id);
        if ($this->Cbuschedules->delete($cbuschedule)) {
            $this->Flash->success(__('The cbuschedule has been deleted.'));
        } else {
            $this->Flash->error(__('The cbuschedule could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
