<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;

class ChangerequestsController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
  
	 public function index(){
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			
			$orderby = ['Changerequests.id' => "ASC"]; //$columnSortOrder];
				
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = ['Changerequests.AccountCode' => $searchValue];									
			}
			
			$where[] = ['Changerequests.id >' => 0];
			
			$q1 = $this->Changerequests->find()
					->where($where)
					->contain([])
					->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$datas = $this->Changerequests->find()
					->where($where)
					->contain([])
					->order($orderby);
			}else{	
				$datas = $this->Changerequests->find()
					->where($where)
					->contain([])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			
			if(!empty($datas)):
				foreach($datas as $u):
					$_link = Router::url(
						['controller' => 'Changerequests', 'action' => 'view', $u->id]
					);
					
					
					$view_link = '<a href="'.$_link.'" 
					title ="Account Details" 
					class = "dropdown-item btn btn-xs btn-outline-success"><div class="preview-thumbnail">
					<i class="typcn typcn-eye menu-icon"></i> Details</div></a>';

					$update_link = Router::url(
						['controller' => 'Changerequests', 'action' => 'edit', $u->id]
					);
					
					$update_link = '<a href="'.$update_link.'" 
					title ="Update Chart of Account" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-edit menu-icon"></i> Update</div></a>';
					
					$actions = $view_link . $update_link;
					
					$act = '      <div class="dropdown">
                          <button class="btn btn-outline-info btn-sm dropdown-toggle" type="button" id="dropdownMenuIconButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-lock-closed"></i>
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton6">
                           
                           '.$actions.'
                          </div>
                        </div>';
						
					
								
				   $_data[] = array( 
						'code'			=> '<span class="bold text-primary">123</span>',
						'title'			=> '<span class="bold text-uppercase text-black">123</span>',	
						'created'		=> '<span class="bold">123</span>',					
						'update'		=> '<span class="bold">12312</span>',							
						'action'		=> $act
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}

	
	
	
	public function view($id=null){
		$request = $this->Changerequests->get($id, [
			'contain' => [],
		]);
			
		$this->set(compact('trans'));
		
	}
	
	public function add($id=null, $no=null, $tcode=null){
			
			/* if(!in_array(['CV', 'JV'], $type)){
				throw new NotFoundException(__('Invalid parameters'));
			}
			 */
			$mtran =  $this->getTableLocator()->get('Transactionmasters');
			
			$mtran = $mtran->get($id, ['contain' => []]);
			$accounts = '';
			$request = $this->Changerequests->newEmptyEntity();
			
			
			if ($this->request->is('post')) {
				$this->ajaxLayout();
				$code = 0;
				
				$data = $this->request->getData();				
				$request = $this->Changerequests->patchEntity($request, $data,  ['validate' => false]);
				
				$error = $this->showError($request);
						
				if(!empty($error)) {
					$this->Log(json_encode($request->getErrors()));
					$msg = '<span class="text-danger">'.$error.'</span>';
				}else{
					
					$request->TransactionCode = $tcode;
					$request->TransactionNumber = $no;
					$request->TransactionDate = date("Y-m-d H:i:s");
					$request->EntryDate = date("Y-m-d H:i:s");
					
					
					if ($this->Changerequests->save($request)) {
						$code = 1; 
						$msg = '<div class="text-success">Account code and amount has been save</div>';
					}else{
						$error = $this->showError($request);
						$this->Log(json_encode($request->getErrors()));
						$msg = '<span class="text-danger">'.$error.'</span>';
					}
				} 
					
				$resp = ['resp' => $code, 'msg' => $msg];
				
				
				$this->response = $this->response->withType('application/json')
				->withStringBody(json_encode($resp));
				
				return $this->response;
			}else{
				$codes =  $this->getTableLocator()->get('Chartofaccounts');
			
				$accounts = $codes->find('list', [
					'keyField' => 'AccountCode',
					'valueField' => 'code_and_title'
				])->toArray();

			}

			$this->set(compact('request', 'no', 'tcode', 'accounts', 'mtran'));
		
    }
	
	public function edit($id=null, $issave=false){
				
			
			$request = $this->Changerequests->get($id, [
				'contain' => [],
			]);
			
			
			if($this->request->is('ajax') && $issave) {
					$this->log(json_encode($this->request->getData()));
					$this->ajaxLayout();
					$code = 0;
				
						$data = $this->request->getData();				
						$request = $this->Changerequests->patchEntity($request, $data);
						
						$error = $this->showError($request);
								
						if(!empty($error)) {
							$this->Log(json_encode($request->getErrors()));
							$msg = '<span class="text-danger">'.$error.'</span>';
						}else{
							
							$request->UpdateDateTime = date("Y-m-d H:i:s");
							
							if ($this->Changerequests->save($request)) {
								
								$code = 1; 
								$msg = '<div class="text-success">Data changes has been saved.</div>';
								
							}else{
								$error = $this->showError($request);
								$this->Log(json_encode($request->getErrors()));
								$msg = '<span class="text-danger">'.$error.'</span>';
							}
						} 
							
						$resp = ['code' => $code, 'msg' => $msg];
						
						
						$this->response = $this->response->withType('application/json')
						->withStringBody(json_encode($resp));
						
						return $this->response;
			}
			
			$this->set(compact('request'));
			
		
    }
	
	
   
}
