<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Chartaccountnews Controller
 *
 * @property \App\Model\Table\ChartaccountnewsTable $Chartaccountnews
 * @method \App\Model\Entity\Chartaccountnews[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ChartaccountnewsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $chartaccountnews = $this->paginate($this->Chartaccountnews);

        $this->set(compact('chartaccountnews'));
    }

    /**
     * View method
     *
     * @param string|null $id Chartaccountnews id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $chartaccountnews = $this->Chartaccountnews->get($id, [
            'contain' => [],
        ]);

        $this->set(compact('chartaccountnews'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $chartaccountnews = $this->Chartaccountnews->newEmptyEntity();
        if ($this->request->is('post')) {
            $chartaccountnews = $this->Chartaccountnews->patchEntity($chartaccountnews, $this->request->getData());
            if ($this->Chartaccountnews->save($chartaccountnews)) {
                $this->Flash->success(__('The chartaccountnews has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The chartaccountnews could not be saved. Please, try again.'));
        }
        $this->set(compact('chartaccountnews'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Chartaccountnews id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $chartaccountnews = $this->Chartaccountnews->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $chartaccountnews = $this->Chartaccountnews->patchEntity($chartaccountnews, $this->request->getData());
            if ($this->Chartaccountnews->save($chartaccountnews)) {
                $this->Flash->success(__('The chartaccountnews has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The chartaccountnews could not be saved. Please, try again.'));
        }
        $this->set(compact('chartaccountnews'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Chartaccountnews id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $chartaccountnews = $this->Chartaccountnews->get($id);
        if ($this->Chartaccountnews->delete($chartaccountnews)) {
            $this->Flash->success(__('The chartaccountnews has been deleted.'));
        } else {
            $this->Flash->error(__('The chartaccountnews could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
