<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Generalledgersummaries Controller
 *
 * @property \App\Model\Table\GeneralledgersummariesTable $Generalledgersummaries
 * @method \App\Model\Entity\Generalledgersummary[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class GeneralledgersummariesController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $generalledgersummaries = $this->paginate($this->Generalledgersummaries);

        $this->set(compact('generalledgersummaries'));
    }

    /**
     * View method
     *
     * @param string|null $id Generalledgersummary id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $generalledgersummary = $this->Generalledgersummaries->get($id, [
            'contain' => [],
        ]);

        $this->set(compact('generalledgersummary'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $generalledgersummary = $this->Generalledgersummaries->newEmptyEntity();
        if ($this->request->is('post')) {
            $generalledgersummary = $this->Generalledgersummaries->patchEntity($generalledgersummary, $this->request->getData());
            if ($this->Generalledgersummaries->save($generalledgersummary)) {
                $this->Flash->success(__('The generalledgersummary has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The generalledgersummary could not be saved. Please, try again.'));
        }
        $this->set(compact('generalledgersummary'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Generalledgersummary id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $generalledgersummary = $this->Generalledgersummaries->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $generalledgersummary = $this->Generalledgersummaries->patchEntity($generalledgersummary, $this->request->getData());
            if ($this->Generalledgersummaries->save($generalledgersummary)) {
                $this->Flash->success(__('The generalledgersummary has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The generalledgersummary could not be saved. Please, try again.'));
        }
        $this->set(compact('generalledgersummary'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Generalledgersummary id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $generalledgersummary = $this->Generalledgersummaries->get($id);
        if ($this->Generalledgersummaries->delete($generalledgersummary)) {
            $this->Flash->success(__('The generalledgersummary has been deleted.'));
        } else {
            $this->Flash->error(__('The generalledgersummary could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
