<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Membercapitalbuildups Controller
 *
 * @property \App\Model\Table\MembercapitalbuildupsTable $Membercapitalbuildups
 * @method \App\Model\Entity\Membercapitalbuildup[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class MembercapitalbuildupsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Members'],
        ];
        $membercapitalbuildups = $this->paginate($this->Membercapitalbuildups);

        $this->set(compact('membercapitalbuildups'));
    }

    /**
     * View method
     *
     * @param string|null $id Membercapitalbuildup id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $membercapitalbuildup = $this->Membercapitalbuildups->get($id, [
            'contain' => ['Members'],
        ]);

        $this->set(compact('membercapitalbuildup'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $membercapitalbuildup = $this->Membercapitalbuildups->newEmptyEntity();
        if ($this->request->is('post')) {
            $membercapitalbuildup = $this->Membercapitalbuildups->patchEntity($membercapitalbuildup, $this->request->getData());
            if ($this->Membercapitalbuildups->save($membercapitalbuildup)) {
                $this->Flash->success(__('The membercapitalbuildup has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The membercapitalbuildup could not be saved. Please, try again.'));
        }
        $members = $this->Membercapitalbuildups->Members->find('list', ['limit' => 200])->all();
        $this->set(compact('membercapitalbuildup', 'members'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Membercapitalbuildup id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $membercapitalbuildup = $this->Membercapitalbuildups->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $membercapitalbuildup = $this->Membercapitalbuildups->patchEntity($membercapitalbuildup, $this->request->getData());
            if ($this->Membercapitalbuildups->save($membercapitalbuildup)) {
                $this->Flash->success(__('The membercapitalbuildup has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The membercapitalbuildup could not be saved. Please, try again.'));
        }
        $members = $this->Membercapitalbuildups->Members->find('list', ['limit' => 200])->all();
        $this->set(compact('membercapitalbuildup', 'members'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Membercapitalbuildup id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $membercapitalbuildup = $this->Membercapitalbuildups->get($id);
        if ($this->Membercapitalbuildups->delete($membercapitalbuildup)) {
            $this->Flash->success(__('The membercapitalbuildup has been deleted.'));
        } else {
            $this->Flash->error(__('The membercapitalbuildup could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
